----------------
title : C++ 레퍼런스 - istream::seekg 함수
cat_title : istream::seekg
ref_title : seekg, istream::seekg
publish_date : 2019-04-19
path : /C++ Reference/iostream
--------------

##@ cpp-ref-start

#@ istream::seekg

`<istream>` 에 정의됨

```cpp-formatted
basic_istream& seekg(pos_type pos);                              // (1)
basic_istream& seekg(off_type off, std::ios_base::seekdir dir);  // (2)
```

연관된 `streambuf` 객체의 입력 위치 지정자 값을 설정한다. 실패 시에 `setstate(std::ios_base::failbit)` 을 호출한다.

처음에 `seekg` 를 호출하면, `eofbit` 을 클리어 한다. 그 후에;

1. 입력 위치 지정자 값을 파일의 시작으로부터의 위치인 `pos` 로 설정한다. 이는 `rdbuf()->pubseekpos(pos, std::ios_base::in)` 를 실행한 것과 같다.
2. 입력 위치 지정자를 `dir` 이 지정한 위치로 부터 `off` 만큼 떨어진 곳으로 설정한다. 이는 `rdbuf()->pubseekoff(off, dir, std::ios_base::in)` 를 실행한 것과 같다.

### 인자들

* `pos`	: 입력 위치 지정자를 설정할 절대 위치.
* `off`	: 입력 위치 지정차를 설정할 상대 위치
* `dir`	: 상대 위치에 기준이 되는 지점. 이는 아래 3 가지 상수들 중 하나 이다.

|상수|설명|
|:------:|-----------|
|`beg`|스트림의 시작점|
|`end`|스트림의 끝점|
|`cur`|위치 지정자의 현재 위치|

### 리턴값

`*this`

### 실행 예제

```cpp-formatted
#include <iostream>
#include <sstream>
#include <string>

int main() {
  std::string str = "Hello, world";
  std::istringstream in(str);
  std::string word1, word2;

  in >> word1;
  in.seekg(0);  // 입력 위치 지정자를 맨 앞으로 움직인다.
  in >> word2;

  std::cout << "word1 = " << word1 << '\n' << "word2 = " << word2 << '\n';
}
```

```exec
word1 = Hello,
word2 = Hello,
```

### 참고 자료

* `tellg` : 입력 위치 지정자의 현재 위치를 리턴한다.
* `tellp` : 출력 위치 지정자를 리턴한다.
* `seekp` : 출력 위치 지정자를 설정한다.